// f2h.cpp : Defines the entry point for the console application.
//



#include "stdafx.h"
#include "f2h.h"
#include "wininet.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// The one and only application object

CWinApp theApp;

using namespace std;


CString sGetProfileStringReg(HKEY hComputerKey, CString& sKey, LPCTSTR lpszEntry, LPCTSTR lpszDefault)
{  
   ASSERT(hComputerKey != NULL);
	ASSERT(lpszEntry != NULL);

   
   HKEY hKeyResult = NULL;

   if (RegOpenKeyEx(hComputerKey, sKey, 0, KEY_QUERY_VALUE, &hKeyResult) != ERROR_SUCCESS)
      return lpszDefault;

	if (hKeyResult == NULL)
		return lpszDefault;

	CString sValue;
	DWORD dwType, dwCount;
	long lResult = RegQueryValueEx(hKeyResult, (LPTSTR)lpszEntry, NULL, &dwType, NULL, &dwCount);
	if (lResult == ERROR_SUCCESS)
	{	
      lResult = RegQueryValueEx(hKeyResult, (LPTSTR)lpszEntry, NULL, &dwType,
			                      (LPBYTE)sValue.GetBuffer(dwCount/sizeof(TCHAR)), &dwCount);
		sValue.ReleaseBuffer();
	}
	RegCloseKey(hKeyResult);
	if (lResult == ERROR_SUCCESS)
	{	ASSERT(dwType == REG_SZ);
		return sValue;
	}
	return lpszDefault;
}

void vReplace( CString& sPara)
{
   sPara.Replace( _T("&"), _T("&amp;"));
//   sPara.Replace( _T("<"), _T("&lt;"));
//   sPara.Replace( _T(">"), _T("&gt;"));
//   sPara.Replace( _T("\'"), _T("&apos;"));
//   sPara.Replace( _T("\""), _T("&quot;"));
   return;
}

int iLevel = 0;
int iSgn=0;
int iFolder = 0;
void Recurse(CFile& F, LPCTSTR pstr)
{
   CFileFind finder;

   CString strWildcard(pstr);
   strWildcard += _T("\\*.*");

   CString sLine;
   BOOL bWorking = finder.FindFile(strWildcard);
   while (bWorking)
   {
      bWorking = finder.FindNextFile();

      // skip . and .. files; otherwise, we'd
      // recur infinitely!
      if (finder.IsDots())
         continue;

      // if it's a directory, recursively search it
      if (finder.IsDirectory())
      {
         CString str = finder.GetFilePath();
         CString sName = finder.GetFileName();
         vReplace( sName);
         iFolder++;
         iSgn++;
         sLine.Format(_T("<node l=\"%d\" name=\"%s\" sgn=\"%d\" folder=\"%d\">\n"), iLevel, sName, iSgn, iFolder);

         F.Write( sLine, sLine.GetLength());

         iLevel++;
            Recurse( F, str);
         iLevel--;

         sLine = _T("</node>\n");
         F.Write( sLine, sLine.GetLength());
      }
      else
      {
         CString str = finder.GetFilePath();
         CString sName = finder.GetFileTitle();
         vReplace( sName);

         TCHAR szUrl[1000];
         BOOL bOk = GetPrivateProfileString( _T("InternetShortcut"), _T("URL"), _T(""), szUrl, 998, str);
         CString sUrl( szUrl);
         vReplace( sUrl);

         iSgn++;
         sLine.Format(_T("<node l=\"%d\" name=\"%s\" url=\"%s\" sgn=\"%d\"/>\n"), iLevel, sName, sUrl, iSgn);
         F.Write( sLine, sLine.GetLength());

         Recurse( F, str);
      }
   }

   finder.Close();
}



int _tmain(int argc, TCHAR* argv[], TCHAR* envp[])
{
	int nRetCode = 0;

	// initialize MFC and print and error on failure
	if (!AfxWinInit(::GetModuleHandle(NULL), NULL, ::GetCommandLine(), 0))
	{
		// TODO: change error code to suit your needs
		cerr << _T("Fatal Error: MFC initialization failed") << endl;
		nRetCode = 1;
	}
	else
	{
      HKEY hKey = HKEY_CURRENT_USER;
		CString sKey("Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders");
		CString sEntry("Favorites");

      CString sFavoDir = sGetProfileStringReg(hKey, sKey, sEntry, _T(""));

      CString sRoot("<Favorites>\n");

      CString sXml(_T("f2h.xml"));
      CFile F( sXml, CFile::modeCreate|CFile::modeReadWrite);

      CString sLine("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n\n<Favorites>\n");
      F.Write( sLine, sLine.GetLength());

         iFolder = iSgn = 0;
         Recurse( F, sFavoDir);
        
      sRoot = "</Favorites>\n";
      F.Write( sRoot, sRoot.GetLength());
      F.Close();

      ::CoInitialize(NULL); 

      IXMLDOMDocumentPtr pDom(_T("Microsoft.XMLDOM"), NULL, CLSCTX_INPROC_SERVER);   
      _variant_t vXml((LPCTSTR) sXml);
      pDom->async = false;
      pDom->load( vXml);

      CString sXsl(_T("f2h.xsl"));
      IXMLDOMDocumentPtr pXsl("Microsoft.XMLDOM", NULL, CLSCTX_INPROC_SERVER);   
      pXsl->async = false;
      _variant_t vXsl((LPCTSTR) sXsl);
      pXsl->load( vXsl);
      
      CString sHtml = pDom->transformNode( pXsl).copy();

      CFile H( _T("f2h.htm"), CFile::modeCreate|CFile::modeReadWrite);
         H.Write( sHtml, sHtml.GetLength());
      H.Close();
   }
	return nRetCode;
}


